/* http://keith-wood.name/datepick.html
   Polish localisation for jQuery Datepicker.
   Written by Jacek Wysocki (jacek.wysocki@gmail.com). */
(function($) {
	'use strict';
	$.datepick.regionalOptions.pl = {
		monthNames: ['Styczeń','Luty','Marzec','Kwiecień','Maj','Czerwiec',
		'Lipiec','Sierpień','Wrzesień','Październik','Listopad','Grudzień'],
		monthNamesShort: ['Sty','Lu','Mar','Kw','Maj','Cze',
		'Lip','Sie','Wrz','Pa','Lis','Gru'],
		dayNames: ['Niedziela','Poniedzialek','Wtorek','Środa','Czwartek','Piątek','Sobota'],
		dayNamesShort: ['Nie','Pn','Wt','Śr','Czw','Pt','So'],
		dayNamesMin: ['N','Pn','Wt','Śr','Cz','Pt','So'],
		dateFormat: 'yyyy-mm-dd',
		firstDay: 1,
		renderer: $.datepick.defaultRenderer,
		prevText: '&#x3c;Poprzedni',
		prevStatus: 'Pokaż poprzedni miesiąc',
		prevJumpText: '&#x3c;&#x3c;',
		prevJumpStatus: '',
		nextText: 'Następny&#x3e;',
		nextStatus: 'Pokaż następny miesiąc',
		nextJumpText: '&#x3e;&#x3e;',
		nextJumpStatus: '',
		currentText: 'Dziś',
		currentStatus: 'Pokaż aktualny miesiąc',
		todayText: 'Dziś',
		todayStatus: 'Pokaż aktualny miesiąc',
		clearText: 'Wyczyść',
		clearStatus: 'Wyczyść obecną datę',
		closeText: 'Zamknij',
		closeStatus: 'Zamknij bez zapisywania',
		yearStatus: 'Pokaż inny rok',
		monthStatus: 'Pokaż inny miesiąc',
		weekText: 'Tydz',
		weekStatus: 'Tydzień roku',
		dayStatus: '\'Wybierz\' D, M d',
		defaultStatus: 'Wybierz datę',
		isRTL: false
	};
	$.datepick.setDefaults($.datepick.regionalOptions.pl);
})(jQuery);
